local player = ...
local pn = ToEnumShortString(player)
local p = PlayerNumber:Reverse()[player]
local pnum = tonumber(pn:sub(-1)) -- there are certainly a lot of player numbers in here aren't there

local rv
local zoom_factor = WideScale(0.8,0.9)

local labelX_col1 = WideScale(-70,-90)
local dataX_col1  = WideScale(-75,-96)

local labelX_col2 = WideScale(10,20)
local dataX_col2  = WideScale(5,15)

local highscoreX = WideScale(56, 80)
local highscorenameX = WideScale(61, 97)

local joining = {false, false}

local PaneItems = {}

PaneItems[THEME:GetString("RadarCategory","Taps")] = {
	-- "rc" is RadarCategory
	rc = 'RadarCategory_TapsAndHolds',
	label = {
		x = labelX_col1,
		y = 150,
	},
	data = {
		x = dataX_col1,
		y = 150
	}
}

PaneItems[THEME:GetString("RadarCategory","Mines")] = {
	rc = 'RadarCategory_Mines',
	label = {
		x = labelX_col2,
		y = 150,
	},
	data = {
		x = dataX_col2,
		y = 150
	}
}

PaneItems[THEME:GetString("RadarCategory","Jumps")] = {
	rc = 'RadarCategory_Jumps',
	label = {
		x = labelX_col1,
		y = 168,
	},
	data = {
		x = dataX_col1,
		y = 168
	}
}

PaneItems[THEME:GetString("RadarCategory","Hands")] = {
	rc = 'RadarCategory_Hands',
	label = {
		x = labelX_col2,
		y = 168,
	},
	data = {
		x = dataX_col2,
		y = 168
	}
}

PaneItems[THEME:GetString("RadarCategory","Holds")] = {
	rc = 'RadarCategory_Holds',
	label = {
		x = labelX_col1,
		y = 186,
	},
	data = {
		x = dataX_col1,
		y = 186
	}
}

PaneItems[THEME:GetString("RadarCategory","Rolls")] = {
	rc = 'RadarCategory_Rolls',
	label = {
		x = labelX_col2,
		y = 186,
	},
	data = {
		x = dataX_col2,
		y = 186
	}
}

local itgcts = {F = WF.ClearTypes.Fail, C = WF.ClearTypes.Clear, N = 0}
local GetNameAndScore = function(machine)
	-- argument is for machine profile
	local song = (GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse()) or GAMESTATE:GetCurrentSong()
	local steps = (GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentTrail(player)) or GAMESTATE:GetCurrentSteps(player)
	local rate = RateFromNumber(SL.Global.ActiveModifiers.MusicRate)
	local score = ""
	local name = ""
	local cleartype
	if (not machine) and (not WF.PlayerProfileStats[pnum]) then return end -- guest or invalid profile

	if song and steps then
		-- note: we're passing in nil for hash here, so we'll want to delay a little so that file parsing
		-- doesn't slow the song wheel
		local stats = WF.FindProfileSongStatsFromSteps(song, steps, rate, nil, (not machine) and pnum or nil)
		local topscore
		local topscoreitem
		if stats then
			local ext = SL["P"..pnum].ActiveModifiers.SimulateITGEnv and "_ITG" or ""
			if not machine then
				topscore = stats["BestPercentDP"..ext]
				cleartype = (ext == "") and stats.BestClearType or itgcts[stats.Cleared_ITG or "N"]
			else
				topscoreitem = stats["HighScoreList"..ext][1]
				if topscoreitem then topscore = topscoreitem.PercentDP end
			end
		end

		if topscore then
			score = string.format("%.2f%%", topscore/100)
			local pprofile
			if not machine then
				pprofile = PROFILEMAN:GetProfile("PlayerNumber_P"..pnum)
				name = "PB" -- only concerned with indicating this is the personal best
			else
				name = topscoreitem.PlayerHSName
			end
		else
			score = string.format("%.2f%%", 0)
			name = "----"
		end
	end

	return score, name, cleartype
end


local af = Def.ActorFrame{
	Name="PaneDisplay"..ToEnumShortString(player),

	InitCommand=function(self)
		self:visible(GAMESTATE:IsHumanPlayer(player))

		if player == PLAYER_1 then
			self:x(_screen.w * 0.25 - 5)
		elseif player == PLAYER_2 then
			self:x( _screen.w * 0.75 + 5)
		end

		self:y(_screen.cy + 5)
	end,

	PlayerJoinedMessageCommand=function(self, params)
		if player==params.Player then
			joining[pnum] = true
			self:visible(true)
				:zoom(0):croptop(0):bounceend(0.3):zoom(1)
				:playcommand("Set")
		end
	end,
	PlayerUnjoinedMessageCommand=function(self, params)
		if player==params.Player then
			joining[pnum] = true
			self:accelerate(0.3):croptop(1):sleep(0.01):zoom(0)
		end
	end,

	-- These playcommand("Set") need to apply to the ENTIRE panedisplay
	-- (all its children) so declare each here
	OnCommand=function(self) self:queuecommand("Set") end,
	CurrentSongChangedMessageCommand=function(self)
		if joining[pnum] then self:finishtweening() joining[pnum] = false return end
		self:stoptweening()
		self:playcommand("Blank")
		self:GetChild("DifficultyIcon"):queuecommand("Set")
		self:sleep(0.5)
		self:queuecommand("Set") end,
	CurrentCourseChangedMessageCommand=function(self)
		if joining[pnum] then self:finishtweening() joining[pnum] = false return end
		self:stoptweening() self:playcommand("Blank")
		self:GetChild("DifficultyIcon"):queuecommand("Set") self:sleep(0.5) self:queuecommand("Set") end,
	["CurrentSteps"..pn.."ChangedMessageCommand"]=function(self)
		if joining[pnum] then self:finishtweening() joining[pnum] = false return end
		self:stoptweening() self:playcommand("Blank")
		self:GetChild("DifficultyIcon"):queuecommand("Set") self:sleep(0.5) self:queuecommand("Set") end,

	SetCommand=function(self)
		local machine_score, machine_name = GetNameAndScore( true )

		self:GetChild("MachineHighScore"):settext(machine_score)
		self:GetChild("MachineHighScoreName"):settext(machine_name):diffuse({0,0,0,1})

		DiffuseEmojis(self, machine_name)

		if PROFILEMAN:IsPersistentProfile(player) then
			local profile = PROFILEMAN:GetProfile(player)
			local player_score, player_name, player_ct = GetNameAndScore()
			local song = GAMESTATE:GetCurrentSong()

			self:GetChild("PlayerHighScore"):settext(player_score)
			self:GetChild("PlayerHighScoreName"):settext(player_name):diffuse({0,0,0,1})
			self:GetChild("ClearTypeQuad"):visible(true)
			self:GetChild("ClearType"):settext(player_ct and WF.ClearTypes[player_ct] or "None")
			self:GetChild("ClearType"):diffuse(WF.ClearTypeColor(player_ct))

			DiffuseEmojis(self, player_name)
		end
	end,
	BlankCommand = function(self)
		for k, v in pairs(PaneItems) do
			self:GetChild(k):GetChild(k.."Num"):settext("")
		end
		self:GetChild("MachineHighScore"):settext("")
		self:GetChild("MachineHighScoreName"):settext("")
		self:GetChild("PlayerHighScore"):settext("")
		self:GetChild("PlayerHighScoreName"):settext("")
		self:GetChild("ClearType"):settext("")
	end
}

-- colored background for chart statistics
af[#af+1] = Def.Quad{
	Name="BackgroundQuad",
	InitCommand=function(self) self:diffuse( PlayerColor(player) )
		self:zoomto(_screen.w/2-10, _screen.h/8):y(_screen.h/2 - 67) end,
	SetCommand=function(self, params)
		if GAMESTATE:IsHumanPlayer(player) then
			local StepsOrTrail = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentTrail(player) or GAMESTATE:GetCurrentSteps(player)

			self:diffuse( PlayerColor(player) )
			--if StepsOrTrail then
			--	local difficulty = StepsOrTrail:GetDifficulty()
			--	self:diffuse( DifficultyColor(difficulty) )
			--else
			--	self:diffuse( PlayerColor(player) )
			--end
		end
	end
}



for key, item in pairs(PaneItems) do

	af[#af+1] = Def.ActorFrame{

		Name=key,
		OnCommand=function(self) self:xy(-_screen.w/20, 6) end,

		-- label
		LoadFont("Common Normal")..{
			Text=key,
			InitCommand=function(self) self:zoom(zoom_factor):xy(item.label.x, item.label.y):diffuse(Color.Black):horizalign(left) end
		},
		--  numerical value
		LoadFont("Common Normal")..{
			Name = key.."Num",
			InitCommand=function(self) self:zoom(zoom_factor):xy(item.data.x, item.data.y):diffuse(Color.Black):horizalign(right) end,
			OnCommand=function(self) self:playcommand("Set") end,
			SetCommand=function(self)
				local SongOrCourse = (GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse()) or GAMESTATE:GetCurrentSong()
				if not SongOrCourse then self:settext("?"); return end

				local steps = (GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentTrail(player)) or GAMESTATE:GetCurrentSteps(player)
				if steps then
					rv = steps:GetRadarValues(player)
					local val = rv:GetValue( item.rc )

					-- the engine will return -1 as the value for autogenerated content; show a question mark instead if so
					self:settext( val >= 0 and val or "?" )
				else
					self:settext( "" )
				end
			end
		}
	}
end

-- chart difficulty icon
af[#af+1] = Def.ActorFrame{
	Name = "DifficultyIcon",
	InitCommand = function(self) self:xy(_screen.w/4 - 34, _screen.h/2 - 67) end,
	Def.Quad{
		InitCommand = function(self) self:diffuse(0,0,0,1):zoom(60) end
	},
	Def.Quad{
		InitCommand = function(self) self:zoom(56):queuecommand("Set") end,
		SetCommand = function(self)
			local SongOrCourse = (GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse()) or GAMESTATE:GetCurrentSong()
			local StepsOrTrail = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentTrail(player) or GAMESTATE:GetCurrentSteps(player)
			if not SongOrCourse then self:diffuse(Color.Black) return end
			if StepsOrTrail then self:diffuse(DifficultyColor(StepsOrTrail:GetDifficulty())) end
		end
	},
	LoadFont("Common Normal")..{
		Name = "DifficultyName",
		InitCommand = function(self) self:xy(-27,-27):horizalign("left"):vertalign("top"):zoom(0.95):diffuse(Color.Black):queuecommand("Set") end,
		SetCommand = function(self)
			local StepsOrTrail = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentTrail(player) or GAMESTATE:GetCurrentSteps(player)
			if StepsOrTrail then
				local diff = ToEnumShortString(StepsOrTrail:GetDifficulty())
				self:settext(THEME:GetString("Difficulty", diff))
			end
		end
	},
	LoadFont("_wendy small")..{
		Name="DifficultyMeter",
		InitCommand=function(self) self:horizalign(right):diffuse(Color.Black):zoom(0.80):xy(26,6):queuecommand("Set") end,
		SetCommand=function(self)
			local SongOrCourse = (GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse()) or GAMESTATE:GetCurrentSong()
			if not SongOrCourse then self:settext(""); return end

			local StepsOrTrail = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentTrail(player) or GAMESTATE:GetCurrentSteps(player)
			local meter = StepsOrTrail and StepsOrTrail:GetMeter() or "?"
			self:settext( meter )
		end
	}
}

--MACHINE high score
af[#af+1] = LoadFont("Common Normal")..{
	Name="MachineHighScore",
	InitCommand=function(self) self:x(highscoreX):y(156):zoom(zoom_factor):diffuse(Color.Black):horizalign(right) end
}

--MACHINE highscore name
af[#af+1] = LoadFont("Common Normal")..{
	Name="MachineHighScoreName",
	InitCommand=function(self) self:x(highscorenameX):y(156):zoom(zoom_factor):diffuse(Color.Black):horizalign(left):maxwidth(80) end
}


--PLAYER PROFILE high score
af[#af+1] = LoadFont("Common Normal")..{
	Name="PlayerHighScore",
	InitCommand=function(self) self:x(highscoreX):y(176):zoom(zoom_factor):diffuse(Color.Black):horizalign(right) end
}

--PLAYER PROFILE highscore name
af[#af+1] = LoadFont("Common Normal")..{
	Name="PlayerHighScoreName",
	InitCommand=function(self) self:x(highscorenameX):y(176):zoom(zoom_factor):diffuse(Color.Black):horizalign(left):maxwidth(80) end
}

--Temp display for cleartype
af[#af+1] = Def.Quad{
	Name = "ClearTypeQuad",
	InitCommand = function(self) self:visible(false):x(highscoreX):y(194):zoomto(WideScale(84, 100), 18):diffuse(0,0,0,0.9) end
}
af[#af+1] = LoadFont("Common Normal")..{
	Name = "ClearType",
	InitCommand = function(self) self:visible(true):x(highscoreX):y(194):zoom(zoom_factor) end
}

return af